
clear; clc;

DATES = xlsread(['LTA_series_v2.xlsx'],'LoanToGDP','A26:A284');
LOANtoGDP = xlsread(['LTA_series_v2.xlsx'],'LoanToGDP','b26:C284');
LOANtoASSET = xlsread(['LTA_series_v2.xlsx'],'Half Land','b26:C284');
Dates_matlab = x2mdate(DATES);

SPESSORE = 2.5;
FontSIZE = 14; 

figure;
subplot(1,2,1)
yyaxis left
plot1 = plot(Dates_matlab,LOANtoGDP(:,1),'linewidth',SPESSORE','color','b'); 
yyaxis right
plot1 = plot(Dates_matlab,LOANtoGDP(:,2),'linewidth',SPESSORE,'linestyle','--','color','r');
set(gca,'Xtick',Dates_matlab); datetick('x','yyyy','keepticks'); 
recessionplot; datetick('x','yyyy','keeplimits');
xticks([712224 715876 719529 723181 726834 730486 734139 737791]);
xticklabels({'1950';'1960';'1970';'1980';'1990';'2000';'2010';'2020'})
grid('on');
title('Loans/GDP','fontsize',FontSIZE);
% title('Credit/GDP','fontsize',FontSIZE);

subplot(1,2,2)
yyaxis left
plot1 = plot(Dates_matlab,LOANtoASSET(:,1),'linewidth',SPESSORE','color','b'); 
yyaxis right
plot1 = plot(Dates_matlab,LOANtoASSET(:,2),'linewidth',SPESSORE,'linestyle','--','color','r');
set(gca,'Xtick',Dates_matlab); datetick('x','yyyy','keepticks'); 
recessionplot; datetick('x','yyyy','keeplimits');
legend1=legend('Households','Firms');
set(legend1,'Edgecolor',[1 1 1],'location','southeast','FontSize',FontSIZE-2);
legend('boxoff');
            
xticks([712224 715876 719529 723181 726834 730486 734139 737791]);
xticklabels({'1950';'1960';'1970';'1980';'1990';'2000';'2010';'2020'})
grid('on');
title('Loans/Assets','fontsize',FontSIZE);
% title('Credit/Assets','fontsize',FontSIZE);
% tightfig;


% saveas(gcf,'LTV_Figures.pdf');
% saveas(gcf,'LTV_Figures.tif');











